clear all
set more off
cd "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\"

use wf_step1011.dta, clear
capture log close
log using C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\log_files\log_step5006.log, replace

*** Population weights
egen sum_age_total = sum(age_total) if smpl2==1, by(year country)
gen pop_wgt =  age_total/sum_age_total

gen EP = BW_newep_1970

foreach var in turnmig_rate share_age_0_24 share_age_55plus WVS_index_2 {
	gen EP_`var'=EP*`var'
}



*==============================================================
*				Estimation sample
*==============================================================

reg  ue2_hyst ///
			turnmig_rate ///
			share_age_0_24 share_age_55plus ///	
			WVS_index_1 WVS_index_2 WVS_index_3 ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector  ///
			ic_EMP_share_female  hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///
			cid_* [aw=pop_wgt]  if smpl2==1  , robust beta 
			
keep if e(sample)

*==============================================================
*				Migration
*==============================================================

*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*		+ controls 
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

reg  ue2_hyst ///
			EP ///
			turnmig_rate ///
			EP_turnmig_rate ///
			share_age_0_24 share_age_55plus  ///
			WVS_index_2 ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
			hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///
			[aw=pop_wgt]  if smpl2==1  , robust beta 

* BIC 
local BIC=(-2*e(ll)+e(df_m)*log(e(N)))/e(N)	

outreg2  ///
			EP ///
			turnmig_rate ///
			EP_turnmig_rate ///
			share_age_0_24 share_age_55plus  ///
			EP_share_age_0_24 EP_share_age_55plus  ///
			WVS_index_2 ///
			EP_WVS_index_2 ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
			hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///		
			using "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\outreg_tables\table5006_EP", ///
			replace	dta ctitle("OLS") dec(2)  nocons  addstat(BIC, `BIC') ///
			sortvar( ///
			EP ///
			turnmig_rate ///
			EP_turnmig_rate ///
			share_age_0_24 share_age_55plus  ///
			EP_share_age_0_24 EP_share_age_55plus  ///
			WVS_index_2 ///
			EP_WVS_index_2 ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
			hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///
			)
			
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*		controls only + FE
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

reg  ue2_hyst ///
			turnmig_rate ///
			EP_turnmig_rate ///
			share_age_0_24 share_age_55plus  ///
			WVS_index_2 ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
			hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///
			cid_* [aw=pop_wgt]  if smpl2==1  , robust beta 

* BIC 
local BIC=(-2*e(ll)+e(df_m)*log(e(N)))/e(N)	
			  
outreg2  ///
			EP ///
			turnmig_rate ///
			EP_turnmig_rate ///
			share_age_0_24 share_age_55plus  ///
			EP_share_age_0_24 EP_share_age_55plus  ///
			WVS_index_2 ///
			EP_WVS_index_2 ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
			hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///		
			using "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\outreg_tables\table5006_EP", ///
			append	dta ctitle("FE") dec(2)  nocons  addstat(BIC, `BIC') ///
			sortvar( ///
			EP ///
			turnmig_rate ///
			EP_turnmig_rate ///
			share_age_0_24 share_age_55plus  ///
			EP_share_age_0_24 EP_share_age_55plus  ///
			WVS_index_2 ///
			EP_WVS_index_2 ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
			hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///
			)
			


*==============================================================
*				Demographics
*==============================================================

*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*		+ controls 
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

reg  ue2_hyst ///
			EP ///
			turnmig_rate ///
			share_age_0_24 share_age_55plus  ///
			EP_share_age_0_24 EP_share_age_55plus  ///
			WVS_index_2 ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
			hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///
			[aw=pop_wgt]  if smpl2==1  , robust beta 

* BIC 
local BIC=(-2*e(ll)+e(df_m)*log(e(N)))/e(N)	

outreg2  ///
			EP ///
			turnmig_rate ///
			EP_turnmig_rate ///
			share_age_0_24 share_age_55plus  ///
			EP_share_age_0_24 EP_share_age_55plus  ///
			WVS_index_2 ///
			EP_WVS_index_2 ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
			hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///		
			using "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\outreg_tables\table5006_EP", ///
			append	dta ctitle("OLS") dec(2)  nocons  addstat(BIC, `BIC') ///
			sortvar( ///
			EP ///
			turnmig_rate ///
			EP_turnmig_rate ///
			share_age_0_24 share_age_55plus  ///
			EP_share_age_0_24 EP_share_age_55plus  ///
			WVS_index_2 ///
			EP_WVS_index_2 ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
			hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///
			)
			
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*		controls only + FE
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

reg  ue2_hyst ///
			turnmig_rate ///
			share_age_0_24 share_age_55plus  ///
			EP_share_age_0_24 EP_share_age_55plus  ///
			WVS_index_2 ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
			hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///
			cid_* [aw=pop_wgt]  if smpl2==1  , robust beta 

* BIC 
local BIC=(-2*e(ll)+e(df_m)*log(e(N)))/e(N)	
			  
outreg2  ///
			EP ///
			turnmig_rate ///
			EP_turnmig_rate ///
			share_age_0_24 share_age_55plus  ///
			EP_share_age_0_24 EP_share_age_55plus  ///
			WVS_index_2 ///
			EP_WVS_index_2 ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
			hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///	
			using "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\outreg_tables\table5006_EP", ///
			append	dta ctitle("FE") dec(2)  nocons  addstat(BIC, `BIC') ///
			sortvar( ///
			EP ///
			turnmig_rate ///
			EP_turnmig_rate ///
			share_age_0_24 share_age_55plus  ///
			EP_share_age_0_24 EP_share_age_55plus  ///
			WVS_index_2 ///
			EP_WVS_index_2 ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
			hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///
			)
			
			
			


*==============================================================
*				Trust
*==============================================================

*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*		+ controls 
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

reg  ue2_hyst ///
			EP ///
			turnmig_rate ///
			share_age_0_24 share_age_55plus  ///
			WVS_index_2 ///
			EP_WVS_index_2 ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
			hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///
			[aw=pop_wgt]  if smpl2==1  , robust beta 

* BIC 
local BIC=(-2*e(ll)+e(df_m)*log(e(N)))/e(N)	

outreg2  ///
			EP ///
			turnmig_rate ///
			EP_turnmig_rate ///
			share_age_0_24 share_age_55plus  ///
			EP_share_age_0_24 EP_share_age_55plus  ///
			WVS_index_2 ///
			EP_WVS_index_2 ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
			hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///	
			using "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\outreg_tables\table5006_EP", ///
			append	dta ctitle("OLS") dec(2)  nocons  addstat(BIC, `BIC') ///
			sortvar( ///
			EP ///
			turnmig_rate ///
			EP_turnmig_rate ///
			share_age_0_24 share_age_55plus  ///
			EP_share_age_0_24 EP_share_age_55plus  ///
			WVS_index_2 ///
			EP_WVS_index_2 ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
			hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///
			)
			
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*		controls only + FE
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

reg  ue2_hyst ///
			turnmig_rate ///
			share_age_0_24 share_age_55plus  ///
			WVS_index_2 ///
			EP_WVS_index_2 ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
			hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///
			cid_* [aw=pop_wgt]  if smpl2==1  , robust beta 

* BIC 
local BIC=(-2*e(ll)+e(df_m)*log(e(N)))/e(N)	
			  
outreg2  ///
			EP ///
			turnmig_rate ///
			EP_turnmig_rate ///
			share_age_0_24 share_age_55plus  ///
			EP_share_age_0_24 EP_share_age_55plus  ///
			WVS_index_2 ///
			EP_WVS_index_2 ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
			hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///
			using "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\outreg_tables\table5006_EP", ///
			append	dta ctitle("FE") dec(2)  nocons  addstat(BIC, `BIC') ///
			sortvar( ///
			EP ///
			turnmig_rate ///
			EP_turnmig_rate ///
			share_age_0_24 share_age_55plus  ///
			EP_share_age_0_24 EP_share_age_55plus  ///
			WVS_index_2 ///
			EP_WVS_index_2 ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
			hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///
			)
			
		

*==============================================================
*				All interactions included
*==============================================================

*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*		+ controls 
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

reg  ue2_hyst ///
			EP ///
			turnmig_rate ///
			EP_turnmig_rate ///
			share_age_0_24 share_age_55plus  ///
			EP_share_age_0_24 EP_share_age_55plus  ///
			WVS_index_2 ///
			EP_WVS_index_2 ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
			hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///
			[aw=pop_wgt]  if smpl2==1  , robust beta 

* BIC 
local BIC=(-2*e(ll)+e(df_m)*log(e(N)))/e(N)	

outreg2  ///
			EP ///
			turnmig_rate ///
			EP_turnmig_rate ///
			share_age_0_24 share_age_55plus  ///
			EP_share_age_0_24 EP_share_age_55plus  ///
			WVS_index_2 ///
			EP_WVS_index_2 ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
			hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///	
			using "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\outreg_tables\table5006_EP", ///
			append	dta ctitle("OLS") dec(2)  nocons  addstat(BIC, `BIC') ///
			sortvar( ///
			EP ///
			turnmig_rate ///
			EP_turnmig_rate ///
			share_age_0_24 share_age_55plus  ///
			EP_share_age_0_24 EP_share_age_55plus  ///
			WVS_index_2 ///
			EP_WVS_index_2 ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
			hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///
			)
			
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*		controls only + FE
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

reg  ue2_hyst ///
			turnmig_rate ///
			EP_turnmig_rate ///
			share_age_0_24 share_age_55plus  ///
			EP_share_age_0_24 EP_share_age_55plus  ///
			WVS_index_2 ///
			EP_WVS_index_2 ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
			hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///
			cid_* [aw=pop_wgt]  if smpl2==1  , robust beta 

* BIC 
local BIC=(-2*e(ll)+e(df_m)*log(e(N)))/e(N)	
			  
outreg2  ///
			EP ///
			turnmig_rate ///
			EP_turnmig_rate ///
			share_age_0_24 share_age_55plus  ///
			EP_share_age_0_24 EP_share_age_55plus  ///
			WVS_index_2 ///
			EP_WVS_index_2 ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
			hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///
			using "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\outreg_tables\table5006_EP", ///
			append	dta ctitle("FE") dec(2)  nocons  addstat(BIC, `BIC') ///
			sortvar( ///
			EP ///
			turnmig_rate ///
			EP_turnmig_rate ///
			share_age_0_24 share_age_55plus  ///
			EP_share_age_0_24 EP_share_age_55plus  ///
			WVS_index_2 ///
			EP_WVS_index_2 ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
			hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///
			)
			
	
	
	
	
		
*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
outreg2  ///
			EP ///
			turnmig_rate ///
			EP_turnmig_rate ///
			share_age_0_24 share_age_55plus  ///
			EP_share_age_0_24 EP_share_age_55plus  ///
			WVS_index_2 ///
			EP_WVS_index_2 ///
			logY_ppp  mlog_road_density city_nuts capital ///
			using "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\outreg_tables\table5006_EP", ///
			groupvar( ///
			turnmig_rate   ///
			share_age_0_24 share_age_55plus ///	
			WVS_index_2  ///
			EP ///
			EP_turnmig_rate ///
			EP_share_age_0_24 EP_share_age_55plus  ///
			EP_WVS_index_2 ///
			)	
			
	
		
log close
	

	
